/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.edideditor;

import com.quantumdata.edideditor.CEADescriptor;
import com.quantumdata.edideditor.CEAGenericVSDB;
import com.quantumdata.edideditor.DataBlock;
import com.quantumdata.edideditor.DescriptorType;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CEAGenericVSDBlock
extends DataBlock {
    private ArrayList<CEAGenericVSDB> aGenericVSDBs;
    private static final int iVendorTag = 3;

    public CEAGenericVSDBlock() {
        super(31);
        this.iDataBlockTagCode = 3;
    }

    @Override
    public void removeDescriptor(int n) {
        this.aGenericVSDBs.remove(n);
        this.adjustDescriptorLength_VendorSpecific(0, 0);
    }

    @Override
    public void removeAllDescriptors() {
        this.aGenericVSDBs.clear();
        this.adjustDescriptorLength_VendorSpecific(0, 0);
    }

    @Override
    public boolean addDescriptor(CEADescriptor cEADescriptor) {
        boolean bl = false;
        if (this.aGenericVSDBs == null) {
            this.aGenericVSDBs = new ArrayList();
        }
        if (this.aGenericVSDBs.size() < this.iMaxNumberDescriptors) {
            this.aGenericVSDBs.add((CEAGenericVSDB)cEADescriptor);
            bl = true;
            this.adjustDescriptorLength_VendorSpecific(1, this.aGenericVSDBs.get(0).getDescriptorLength());
        } else {
            bl = false;
        }
        return bl;
    }

    public ArrayList<CEAGenericVSDB> getDescriptors() {
        return this.aGenericVSDBs;
    }

    public CEAGenericVSDB getGenericVSDBs(int n) {
        if (n == 0 && this.aGenericVSDBs.size() >= 1) {
            return this.aGenericVSDBs.get(n);
        }
        return null;
    }

    public void clearDescriptors() {
        this.aGenericVSDBs.clear();
        this.aGenericVSDBs = null;
        this.adjustDescriptorLength_VendorSpecific(0, 0);
    }

    @Override
    public String getDataBlockName() {
        return DescriptorType.GENERIC_VSDB_DES.getBlockName();
    }

    @Override
    public String uploadDataBlockData(String string) {
        String string2 = null;
        super.setHeader(string.substring(0, 2));
        CEAGenericVSDB cEAGenericVSDB = new CEAGenericVSDB();
        cEAGenericVSDB.uploadDescriptorData(string.substring(2, string.length()));
        if (this.aGenericVSDBs == null) {
            this.aGenericVSDBs = new ArrayList(1);
            this.aGenericVSDBs.add(cEAGenericVSDB);
            this.adjustDescriptorLength_VendorSpecific(1, this.aGenericVSDBs.get(0).getDescriptorLength());
        } else {
            string2 = "ERROR: Max descriptors already reached!";
        }
        return string2;
    }

    @Override
    public String extractDataBlockData() {
        this.adjustDescriptorLength_VendorSpecific(this.getCurrentNumDescriptors(), this.aGenericVSDBs.get(0).getDescriptorLength());
        String string = new String();
        string = string.concat(super.getHeader());
        if (this.getCurrentNumDescriptors() >= 1) {
            string = string.concat(this.aGenericVSDBs.get(0).extractDescriptorData());
        }
        return string;
    }

    @Override
    public boolean isJustOneCopyAllowed() {
        return false;
    }

    @Override
    public int getDataBlockChecksum() {
        String string = this.extractDataBlockData();
        int n = string.length();
        int n2 = 0;
        for (int i = 0; i < n; i += 2) {
            n2 += Integer.parseInt(string.substring(i, i + 2), 16);
        }
        return n2 & 0xFF;
    }
}

